<?php
require_once __DIR__ . '/../config/database.php';

try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_PERSISTENT => true,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ]
    );

    // Add new columns for message logging
    $alterQueries = [
        "ALTER TABLE system_logs ADD COLUMN IF NOT EXISTS action_type VARCHAR(50) NULL AFTER action",
        "ALTER TABLE system_logs ADD COLUMN IF NOT EXISTS message_type ENUM('sms', 'email', 'whatsapp') NULL AFTER action_type",
        "ALTER TABLE system_logs ADD COLUMN IF NOT EXISTS message_status ENUM('success', 'failed', 'pending') NULL AFTER message_type",
        "ALTER TABLE system_logs ADD COLUMN IF NOT EXISTS recipient VARCHAR(255) NULL AFTER message_status",
        "ALTER TABLE system_logs ADD COLUMN IF NOT EXISTS message_content TEXT NULL AFTER recipient",
        "ALTER TABLE system_logs ADD COLUMN IF NOT EXISTS error_message TEXT NULL AFTER message_content"
    ];

    foreach ($alterQueries as $query) {
        $pdo->exec($query);
        echo "Executed: " . substr($query, 0, 50) . "...\n";
    }

    // Add indexes for better performance
    $indexQueries = [
        "CREATE INDEX IF NOT EXISTS idx_message_type ON system_logs(message_type)",
        "CREATE INDEX IF NOT EXISTS idx_message_status ON system_logs(message_status)",
        "CREATE INDEX IF NOT EXISTS idx_action_type ON system_logs(action_type)",
        "CREATE INDEX IF NOT EXISTS idx_created_at ON system_logs(created_at)"
    ];

    foreach ($indexQueries as $query) {
        $pdo->exec($query);
        echo "Created index: " . substr($query, 0, 30) . "...\n";
    }

    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
}
?> 